Info Tech, Inc. sponsors a student shadowing program with the University of Florida. The program provides students with real life experience working on a software development project. This repository contains the results of Kayla Barrer's shadowing program project from the Spring of 2018. 

# File Friend

File Friend is a web app that performs secure, peer-to-peer file transfers in real time that are not stored by any third party. You can also use video chat while transferring files!

Want to try it out? Contact me at kaylabarrera2@gmail.com for an invite!

[Click here](https://docs.google.com/presentation/d/131YzhAAn_Nh0gxDtZbyjUfITw6t5ZtIfuh0jDlxoLkw/edit?usp=sharing) for a presentation about File Friend.

## How Does it Work?

1. Send an email invite to your friend that you would like to send a file to.
2. Wait for them to connect by clicking the link in the email.
3. Tell your browser to allow video and microphone access.
4. Send and receive files!

## Getting Started

### Prerequisites

This app requires knowledge of:

* HTML
  * [W3 Schools Tutorial](https://www.w3schools.com/html/)
* CSS
  * [W3 Schools Tutorial](https://www.w3schools.com/css/)
* Javascript
  * [W3 Schools Tutorial](https://www.w3schools.com/js/default.asp)
* Bulma
  * See [Bulma's documentation](https://bulma.io/documentation/) for help.
* Vue.js
  * Check out [Vue's docs](https://vuejs.org/v2/guide/) as well.

## Built With

* [Atom](https://flight-manual.atom.io/getting-started/sections/installing-atom/) - Text editor & IDE
* [Vue.js](https://vuejs.org/) - Javascript framework
* [Bulma](https://bulma.io/) - CSS framework
* [Parcel.js](https://parceljs.org/getting_started.html) - Asset Manager & Local Development Server
* [SimpleWebRTC Library](https://simplewebrtc.com/notsosimple.html#filetransfer) - For sending and receiving files ([Demo](https://simplewebrtc.com/filetransfer))
* [Twilio](https://www.twilio.com/) - STUN/TURN Server for peer-to-peer transfers
* [GitLab](https://about.gitlab.com/) - Version Control
* [Amazon Web Services](https://aws.amazon.com/) - S3 Buckets, CloudFront, Lambda, API Gateway, and Command Line Interface
* [Yarn](https://yarnpkg.com/en/) - Package Manager
* [Homebrew](https://brew.sh/) - Package Manager & Installer
* [Prettier](https://prettier.io/docs/en/install.html) - Code Formatter
* Developed with Mac OS

## Constraints

This app may have difficulty in certain browsers such as Safari and on mobile devices.

The **speed and ability to transfer files will vary** based on the quality of your **network connection.**

## Twilio Warning

Please note that running this application with a significant amount of traffic or users will be expensive due to how costly TURN servers are. Please review Twilio's TURN service bandwidth rates.

## Authors

* **Kayla Barrera**
* **River Ross**

Owner: Info Tech, Inc.
